"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defineCustomElement = exports.createForwardRef = exports.mergeRefs = exports.setRef = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const setRef = (ref, value) => {
    if (typeof ref === 'function') {
        ref(value);
    }
    else if (ref != null) {
        // Cast as a MutableRef so we can assign current
        ref.current = value;
    }
};
exports.setRef = setRef;
const mergeRefs = (...refs) => {
    return (value) => {
        refs.forEach((ref) => {
            exports.setRef(ref, value);
        });
    };
};
exports.mergeRefs = mergeRefs;
const createForwardRef = (ReactComponent, displayName) => {
    const forwardRef = (props, ref) => {
        return react_1.default.createElement(ReactComponent, Object.assign({}, props, { forwardedRef: ref }));
    };
    forwardRef.displayName = displayName;
    return react_1.default.forwardRef(forwardRef);
};
exports.createForwardRef = createForwardRef;
const defineCustomElement = (tagName, customElement) => {
    if (customElement !== undefined && typeof customElements !== 'undefined' && !customElements.get(tagName)) {
        customElements.define(tagName, customElement);
    }
};
exports.defineCustomElement = defineCustomElement;
tslib_1.__exportStar(require("./attachProps"), exports);
tslib_1.__exportStar(require("./case"), exports);
//# sourceMappingURL=index.js.map