export const handleTimestamp = (value, hour24 = false) => {
  if (!(value instanceof Date) && typeof value !== 'string') {
    throw new TypeError('Timestamp prop must be a Date object or a string.');
  }
  return new Date(value)
    .toLocaleDateString(undefined, {
    year: 'numeric',
    month: '2-digit',
    day: '2-digit',
    hour: '2-digit',
    minute: '2-digit',
    hour12: !hour24
  })
    .replace(',', '');
};
export const getGlobalEmojiUrl = (emojiName) => { var _a, _b; return (_b = (_a = window.$discordMessage) === null || _a === void 0 ? void 0 : _a.emojis) === null || _b === void 0 ? void 0 : _b[emojiName]; };
//# sourceMappingURL=util.js.map
