import { h, Host } from '@stencil/core';
import Fragment from '../../Fragment';
import { avatars, profiles } from '../../options';
import VerifiedTick from '../svgs/verified-tick';
export class DiscordThreadMessage {
  constructor() {
    this.profile = undefined;
    this.author = 'User';
    this.avatar = undefined;
    this.bot = false;
    this.server = false;
    this.verified = false;
    this.edited = false;
    this.roleColor = undefined;
    this.relativeTimestamp = '1m ago';
  }
  render() {
    var _a, _b;
    const resolveAvatar = (avatar) => { var _a, _b; return (_b = (_a = avatars[avatar]) !== null && _a !== void 0 ? _a : avatar) !== null && _b !== void 0 ? _b : avatars.default; };
    const defaultData = { author: this.author, bot: this.bot, verified: this.verified, server: this.server, roleColor: this.roleColor };
    const profileData = (_a = Reflect.get(profiles, this.profile)) !== null && _a !== void 0 ? _a : {};
    const profile = Object.assign(Object.assign(Object.assign({}, defaultData), profileData), { avatar: resolveAvatar((_b = profileData.avatar) !== null && _b !== void 0 ? _b : this.avatar) });
    return (h(Host, { class: "discord-thread-message" }, h("img", { src: profile.avatar, class: "discord-thread-message-avatar", alt: profile.author }), h(Fragment, null, profile.bot && !profile.server && (h("span", { class: "discord-application-tag" }, profile.verified && h(VerifiedTick, null), "Bot")), profile.server && !profile.bot && h("span", { class: "discord-application-tag" }, "Server")), h("span", { class: "discord-thread-message-username", style: { color: profile.roleColor } }, profile.author), h("div", { class: "discord-thread-message-content" }, h("slot", null), this.edited ? h("span", { class: "discord-message-edited" }, "(edited)") : ''), h("span", { class: "discord-thread-message-timestamp" }, this.relativeTimestamp)));
  }
  static get is() { return "discord-thread-message"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-thread-message.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-thread-message.css"]
    };
  }
  static get properties() {
    return {
      "profile": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The id of the profile data to use."
        },
        "attribute": "profile",
        "reflect": false
      },
      "author": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "default",
              "text": "'User'"
            }],
          "text": "The message author's username."
        },
        "attribute": "author",
        "reflect": false,
        "defaultValue": "'User'"
      },
      "avatar": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The message author's avatar. Can be an avatar shortcut, relative path, or external link."
        },
        "attribute": "avatar",
        "reflect": false
      },
      "bot": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether the message author is a bot or not.\nOnly works if `server` is `false` or `undefined`."
        },
        "attribute": "bot",
        "reflect": false,
        "defaultValue": "false"
      },
      "server": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether the message author is a server crosspost webhook or not.\nOnly works if `bot` is `false` or `undefined`."
        },
        "attribute": "server",
        "reflect": false,
        "defaultValue": "false"
      },
      "verified": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether the bot is verified or not.\nOnly works if `bot` is `true`"
        },
        "attribute": "verified",
        "reflect": false,
        "defaultValue": "false"
      },
      "edited": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether the message has been edited or not."
        },
        "attribute": "edited",
        "reflect": false,
        "defaultValue": "false"
      },
      "roleColor": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The message author's primary role color. Can be any [CSS color value](https://www.w3schools.com/cssref/css_colors_legal.asp)."
        },
        "attribute": "role-color",
        "reflect": false
      },
      "relativeTimestamp": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The relative timestamp of the message."
        },
        "attribute": "relative-timestamp",
        "reflect": false,
        "defaultValue": "'1m ago'"
      }
    };
  }
  static get elementRef() { return "el"; }
}
//# sourceMappingURL=discord-thread-message.js.map
