import { h } from '@stencil/core';
import { defaultDiscordAvatars } from '../../options';
import GuildBadge from '../svgs/guild-badge';
import PartnerBadgeOverlay from '../svgs/partner-badge-overlay';
import VerifiedBadgeOverlay from '../svgs/verified-badge-overlay';
export class DiscordInvite {
  constructor() {
    this.icon = defaultDiscordAvatars.blue;
    this.name = 'Discord Server';
    this.url = undefined;
    this.online = 0;
    this.members = 0;
    this.verified = false;
    this.partnered = false;
    this.inviteTitle = "You've been invited to join a server";
    this.joinBtn = 'Join';
  }
  render() {
    return (h("div", { class: "discord-invite" }, h("div", { class: "discord-invite-header" }, this.inviteTitle), h("div", { class: "discord-invite-root" }, h("img", { class: "discord-invite-icon", src: this.icon, alt: this.name }), h("div", { class: "discord-invite-info" }, h("div", { class: "discord-invite-title" }, ((this.verified && !this.partnered) || (!this.verified && this.partnered)) && (h("div", { class: "discord-invite-badge" }, h(GuildBadge, { "aria-label": this.partnered ? 'Discord Partner' : 'Verified', class: `discord-invite-badge-${this.partnered ? 'partnered' : 'verified'}` }), h("div", { class: "discord-invite-badge-container" }, this.partnered ? h(PartnerBadgeOverlay, null) : h(VerifiedBadgeOverlay, null)))), h("span", { class: "discord-invite-name" }, this.name)), h("div", { class: "discord-invite-counts" }, h("i", { class: "discord-invite-status discord-invite-status-online" }), h("span", { class: "discord-invite-count" }, this.online.toLocaleString(), " Online"), h("i", { class: "discord-invite-status" }), h("span", { class: "discord-invite-count" }, this.members.toLocaleString(), " Members"))), h("a", { class: "discord-invite-join", href: this.url, target: "_blank", rel: "noopener noreferrer" }, this.joinBtn))));
  }
  static get is() { return "discord-invite"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-invite.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-invite.css"]
    };
  }
  static get properties() {
    return {
      "icon": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string | undefined",
          "resolved": "string | undefined",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The server icon to display for the invite."
        },
        "attribute": "icon",
        "reflect": false,
        "defaultValue": "defaultDiscordAvatars.blue"
      },
      "name": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "default",
              "text": "'Discord Server'"
            }],
          "text": "The server's name."
        },
        "attribute": "name",
        "reflect": false,
        "defaultValue": "'Discord Server'"
      },
      "url": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The URL to open when you click on the join button."
        },
        "attribute": "url",
        "reflect": false
      },
      "online": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "default",
              "text": "0"
            }],
          "text": "The number of members online on the server."
        },
        "attribute": "online",
        "reflect": false,
        "defaultValue": "0"
      },
      "members": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "default",
              "text": "0"
            }],
          "text": "The number of members on the server."
        },
        "attribute": "members",
        "reflect": false,
        "defaultValue": "0"
      },
      "verified": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether the server is verified.\nOnly works if `partnered` is `false` or `undefined`."
        },
        "attribute": "verified",
        "reflect": false,
        "defaultValue": "false"
      },
      "partnered": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether the server is partnered.\nOnly works if `verified` is `false` or `undefined`."
        },
        "attribute": "partnered",
        "reflect": false,
        "defaultValue": "false"
      },
      "inviteTitle": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "default",
              "text": "\"You've been invited to join a server\""
            }],
          "text": "Invitation embed title."
        },
        "attribute": "invite-title",
        "reflect": false,
        "defaultValue": "\"You've been invited to join a server\""
      },
      "joinBtn": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "default",
              "text": "'Join'"
            }],
          "text": "The join button."
        },
        "attribute": "join-btn",
        "reflect": false,
        "defaultValue": "'Join'"
      }
    };
  }
  static get elementRef() { return "el"; }
}
//# sourceMappingURL=discord-invite.js.map
