import { Host, h } from '@stencil/core';
export class DiscordHeader {
  constructor() {
    this.guild = undefined;
    this.channel = undefined;
    this.icon = undefined;
  }
  render() {
    return (h(Host, { class: "discord-header" }, h("div", { class: "discord-header-icon" }, 
    // if no guild icon, create one using the first letter of the guild name
    this.icon ? (h("img", { src: this.icon, alt: "guild icon" })) : (h("div", null, h("span", null, (() => {
      const split = this.guild.split(' ');
      return split.length > 1 ? split[0][0] + split[1][0] : split[0][0];
    })())))), h("div", { class: "discord-header-text" }, h("div", { class: "discord-header-text-guild" }, this.guild), h("div", { class: "discord-header-text-channel" }, "#", this.channel), h("slot", null))));
  }
  static get is() { return "discord-header"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-header.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-header.css"]
    };
  }
  static get properties() {
    return {
      "guild": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The guild name"
        },
        "attribute": "guild",
        "reflect": false
      },
      "channel": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The name of the channel"
        },
        "attribute": "channel",
        "reflect": false
      },
      "icon": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string | undefined",
          "references": {}
        },
        "required": false,
        "optional": true,
        "docs": {
          "tags": [],
          "text": "The icon to display."
        },
        "attribute": "icon",
        "reflect": false
      }
    };
  }
}
//# sourceMappingURL=discord-header.js.map
