import { h, Host } from '@stencil/core';
import clsx from 'clsx';
import { getGlobalEmojiUrl } from '../../util';
export class DiscordEmbedField {
  constructor() {
    this.validInlineIndices = new Set([1, 2, 3]);
    this.fieldTitle = undefined;
    this.inline = false;
    this.inlineIndex = 1;
  }
  checkInlineIndex(value) {
    if (!this.validInlineIndices.has(Number(value)))
      throw new RangeError('DiscordEmbedField `inlineIndex` prop must be one of: 1, 2, or 3');
  }
  componentWillRender() {
    this.checkInlineIndex(this.inlineIndex);
  }
  render() {
    const parent = this.el.parentElement;
    if (parent.tagName.toLowerCase() !== 'discord-embed-fields') {
      throw new SyntaxError('All <discord-embed-field> components must be direct children of <discord-embed-fields>.');
    }
    const emojiParsedEmbedFieldTitle = this.parseTitle(this.fieldTitle);
    return (h(Host, { class: clsx({
        'discord-embed-inline-field': this.inline,
        'discord-embed-inline-field-1': this.inline && this.inlineIndex === 1,
        'discord-embed-inline-field-2': this.inline && this.inlineIndex === 2,
        'discord-embed-inline-field-3': this.inline && this.inlineIndex === 3
      }, 'discord-embed-field') }, emojiParsedEmbedFieldTitle && h("div", { class: "discord-field-title" }, [...emojiParsedEmbedFieldTitle]), h("slot", null)));
  }
  parseTitle(title) {
    if (!title)
      return null;
    const words = title.split(' ');
    return words.map((word, idx) => {
      var _a;
      const emoji = (_a = getGlobalEmojiUrl(word)) !== null && _a !== void 0 ? _a : {};
      let el = '';
      if (emoji.name) {
        el = (h("span", { class: "discord-embed-custom-emoji" }, h("img", { src: emoji.url, alt: emoji.name, class: "discord-embed-custom-emoji-image" }), h("span", null, "\u00A0")));
      }
      else {
        el = idx < words.length - 1 ? `${word} ` : word;
      }
      return el;
    });
  }
  static get is() { return "discord-embed-field"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-embed-field.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-embed-field.css"]
    };
  }
  static get properties() {
    return {
      "fieldTitle": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": true,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The field's title."
        },
        "attribute": "field-title",
        "reflect": false
      },
      "inline": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether this field should be displayed inline or not."
        },
        "attribute": "inline",
        "reflect": false,
        "defaultValue": "false"
      },
      "inlineIndex": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "remark",
              "text": "This defines the position of this inline field. 1 is left, 2 is middle and 3 is right."
            }, {
              "name": "oneof",
              "text": "[1, 2, 3]"
            }, {
              "name": "default",
              "text": "1"
            }],
          "text": "The index of this inline field"
        },
        "attribute": "inline-index",
        "reflect": false,
        "defaultValue": "1"
      }
    };
  }
  static get elementRef() { return "el"; }
  static get watchers() {
    return [{
        "propName": "inlineIndex",
        "methodName": "checkInlineIndex"
      }];
  }
}
//# sourceMappingURL=discord-embed-field.js.map
