import { h } from '@stencil/core';
import { getGlobalEmojiUrl } from '../../util';
export class DiscordCustomEmoji {
  constructor() {
    this.name = undefined;
    this.url = undefined;
    this.embedEmoji = undefined;
    this.largeEmoji = false;
  }
  componentWillRender() {
    var _a, _b, _c, _d;
    if (!this.url && Boolean(this.name)) {
      const emojiFromGlobal = getGlobalEmojiUrl(this.name);
      if (emojiFromGlobal) {
        (_a = this.url) !== null && _a !== void 0 ? _a : (this.url = (_b = emojiFromGlobal.url) !== null && _b !== void 0 ? _b : '');
        (_c = this.embedEmoji) !== null && _c !== void 0 ? _c : (this.embedEmoji = (_d = emojiFromGlobal.embedEmoji) !== null && _d !== void 0 ? _d : false);
      }
    }
  }
  render() {
    const name = `:${this.name}:`;
    const emojiClassName = this.embedEmoji ? 'discord-embed-custom-emoji' : 'discord-custom-emoji';
    let emojiImageClassName = this.embedEmoji ? 'discord-embed-custom-emoji-image' : 'discord-custom-emoji-image';
    if (this.largeEmoji) {
      emojiImageClassName += ' discord-custom-emoji-image-large';
    }
    return (h("span", { class: emojiClassName }, h("img", { "aria-label": name, src: this.url, alt: name, draggable: false, class: emojiImageClassName })));
  }
  static get is() { return "discord-custom-emoji"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-custom-emoji.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-custom-emoji.css"]
    };
  }
  static get properties() {
    return {
      "name": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The name of the emoji"
        },
        "attribute": "name",
        "reflect": false
      },
      "url": {
        "type": "string",
        "mutable": true,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The emoji URL to use in the message."
        },
        "attribute": "url",
        "reflect": false
      },
      "embedEmoji": {
        "type": "boolean",
        "mutable": true,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Determines whether or not the emoji is used in an embed, or a message.\nIf it is used in an embed, the sizing is adjusted accordingly."
        },
        "attribute": "embed-emoji",
        "reflect": false
      },
      "largeEmoji": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The emoji size"
        },
        "attribute": "large-emoji",
        "reflect": false,
        "defaultValue": "false"
      }
    };
  }
  static get elementRef() { return "el"; }
}
//# sourceMappingURL=discord-custom-emoji.js.map
