import { Host, h } from '@stencil/core';
import hljs from 'highlight.js';
export class DiscordCodeBlock {
  constructor() {
    this.language = undefined;
    this.code = undefined;
  }
  render() {
    // check if hljs has the language
    const language = this.language ? (hljs.getLanguage(this.language) ? this.language : 'plaintext') : 'plaintext';
    return (h(Host, { class: "discord-code-block-pre discord-code-block-pre--multiline language" }, h("code", { class: `hljs language-${language}`, innerHTML: hljs.highlight(this.code, { language }).value })));
  }
  static get is() { return "discord-code-block"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-code-block.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-code-block.css"]
    };
  }
  static get properties() {
    return {
      "language": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string | undefined",
          "references": {}
        },
        "required": false,
        "optional": true,
        "docs": {
          "tags": [],
          "text": "The language of the code block."
        },
        "attribute": "language",
        "reflect": false
      },
      "code": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The code to display."
        },
        "attribute": "code",
        "reflect": false
      }
    };
  }
}
//# sourceMappingURL=discord-code-block.js.map
